<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<section class="py-lg-3 py-4">
    <div class="container">
        <div class="row">
            <div class="col-md-5 m-auto">
                <div class="card box-shadow-xl overflow-hidden mb-4">
                    <form class="form-modal p-xl-3" action="<?= base_url('auth-call/verify') ?>" method="POST">
                        <div class="card-body pt-1">
                            <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                            
                            <div class="card-header px-4 py-2">
                                <h1 class="bold text-center">تایید شماره همراه</h1>
                            </div>

                            <div class="row" id="alert-message">
                                <div class="col-12">
                                    <?php if (isset($error_message)) : ?>
                                        <div class="alert alert-danger">
                                            <?= $error_message ?>
                                        </div>
                                    <?php elseif ($this->session->flashdata('frontend_success')) : ?>
                                        <div class="alert alert-success">
                                            <?= $this->session->flashdata('frontend_success') ?>
                                        </div>
                                    <?php elseif ($this->session->flashdata('frontend_error')) : ?>
                                        <div class="alert alert-danger">
                                            <?= $this->session->flashdata('frontend_error') ?>
                                        </div>
                                    <?php endif; ?>
                                </div><!-- /.col -->
                            </div><!-- /.row -->

                            <div class="row">

                                <div class="col-12 col-12 pe-2 mb-3">
                                    <label>کد تایید</label>
                                    <input type="number" class="form-control numeric ltr text-center font-lg" autocomplete="off" name="code" value="<?= set_value('code') ?>">
                                </div><!-- /.col-12 -->

                                <?php if (0 && isset($captcha_image)) : ?>
                                    <div class="col-12 col-12 pe-2 mb-3 col-field col-captcha">
                                        <label>
                                            کد امنیتی:
                                            <a href="javascript:void(0);" class="btn-link text-dark reload-captcha" tabindex="-1"><i class="fa fa-undo"></i> کد جدید</a>
                                        </label>
                                        <div class="row">
                                            <div class="col-7 captcha-image">
                                                <?= $captcha_image ?>
                                            </div>
                                            <div class="col-5">
                                                <input type="number" class="form-control txt-captcha text-center ltr font-lg numeric tahoma" name="captcha" title="کد امنیتی" required>
                                            </div>
                                        </div>
                                        <div class="help-block"></div>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                            </div><!-- /.row -->

                            <div class="text-center <?= $remain_seconds ? '' : 'hide' ?>" id="ticker-box">
                                <span>زمان باقی مانده تا درخواست کد جدید: </span>
                                <span class="bold">
                                    (<span id="minutes"></span><span class="colon">:</span><span id="seconds"></span>)
                                </span>
                            </div>
                            <div class="text-center">
                                <a class="underline <?= $remain_seconds ? 'hide' : '' ?>" id="btn-resend-sms" href="javascript:void(0)">ارسال مجدد کد فعال سازی</a>
                                <div id="status-new-code"></div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-6 m-auto">
                                    <button class="btn bg-gradient-primary w-100" name="submit" value="submit">
                                        ثبت
                                    </button>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.card-body -->
                    </form>
                </div><!-- /.card -->

                <div class="text-center">
                    <a href="<?= base_url('') ?>"> <i class="fa fa-arrow-right"></i> بازگشت به صفحه اصلی</a>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</section>
<script>
    let remainSeconds = <?= $remain_seconds ?>;
    let verifyCodeCooldown = <?= $verify_code_cooldown ?>;
</script>