<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

if(!isset($unpublish_footer)):
?>
<footer>
    <div class="bottom-menu-box">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="bottom-menu">
                        <?php
                        if (isset($first_column_footer) && count($first_column_footer)) {
                            foreach ($first_column_footer as $value) {
                                if ($value->type == 'custom') {
                                    $url = $value->url;
                                } else {
                                    $url = base_url() . $value->url;
                                }
                                ?>
                                <li>
                                    <a href="<?= $url ?>"><?= $value->title ?></a>
                                </li>
                                <?php
                            }
                        }
                        ?>
                    </ul>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div><!-- /.bottom-menu-box -->

    <div class="footer p-t-10">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="center-block text-center certificates">
                        <?php
                        if ($settings->enamad){
                            if($settings->enamad == 'demo'){
                                ?>
                                <img src="<?=base_url() ?>assets/images/enamad.png" alt="اینماد">
                                <?php
                            }else{
                                echo $settings->enamad;
                            }
                        }
                        if ($settings->samandehi){
                            if($settings->samandehi == 'demo'){
                                ?>
                                <img src="<?=base_url() ?>assets/images/samandehi.png" alt="ساماندهی">
                                <?php
                            }else{
                                echo $settings->samandehi;
                            }
                        }
                        ?>
                    </div>
                </div><!-- /.col -->

                <div class="col-lg-7 col-12 footer-right">
                    <p class="owner-copyright">
                        کلیه حقوق این سایت متعلق به
                        <a href="<?= base_url() ?>"><?= $settings->site_name ?></a>
                        می باشد.
                    </p>
                    <p class="rayanik-copyright">
                        طراحی و پیاده سازی اسکریپت کارتا 
                    </p>
                </div><!-- /.col -->

                <div class="col-lg-5 col-12 order-first order-lg-last">
                    <div class="socials-box">
                        <ul class="socials">
                            <?php
                            if ($settings->social_networks) {
                                foreach ($settings->social_networks as $social_network) {
                                    ?>
                                    <li class="<?= $social_network->social_network ?>">
                                        <a rel="me" href="<?= $social_network->url ?>" title="<?= $social_network->title; ?>" target="_blank" class="    has-tooltip">
                                            <?php
                                            if ($social_network->social_network == 'aparat') {
                                                echo  $social_network->class;
                                            } else {
                                                ?>
                                                <i class="<?= $social_network->class ?>"></i>
                                                <?php
                                            }
                                            ?>
                                        </a>
                                    </li>
                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </div><!-- /.socials-box -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div><!-- /.footer -->
</footer>
<?php endif; ?>

<?php if(isset($show_modal_card2card)): ?>
    <div id="modal-card2card" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    <h4 class="modal-title">کارت به کارت</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="alert-original d-none">
                                <?= $settings->card2card_alert ?>
                            </div>
                            <div class="alert-card2card">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>شماره پیگیری تراکنش :</label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" tabindex="1" id="txt-reference" maxlength="16" class="form-control ltr" placeholder="شماره پیگیری" title="شماره پیگیری" required>
                                    <div class="help-block"></div>
                                </div>
                            </div><!-- /.form-group -->
                            
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>شماره کارت واریز کننده :</label>
                                </div>
                                <div class="col-sm-8">
                                    <div class="row card-inputs" required>
                                        <input type="hidden" class="txt-card" title="شماره کارت" required data-validation="validCardNumber">
                                        <div class="col-3">
                                            <input type="text" tabindex="5" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                        </div>
                                        <div class="col-3">
                                            <input type="text" tabindex="4" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                        </div>
                                        <div class="col-3">
                                            <input type="text" tabindex="3" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                        </div>
                                        <div class="col-3">
                                            <input type="text" tabindex="2" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                        </div>
                                    </div><!-- /.row -->
                                    <div class="help-block"></div>
                                </div>
                            </div><!-- /.form-group -->
                            
                            <div class="row">
                                <div class="col-sm-4">
                                    <label>تاریخ و ساعت پرداخت:</label>
                                </div>
                                <div class="col-sm-8">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" tabindex="6" id="txt-date" class="form-control ltr text-left" maxlength="10" autocomplete="off" title="تاریخ پرداخت" required>
                                                <div class="help-block"></div>
                                            </div>  
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <input type="text" tabindex="7" id="txt-clock" class="form-control ltr text-left" maxlength="5" placeholder="با فرمت 20:30" autocomplete="off" title="ساعت پرداخت" required>
                                                <div class="help-block"></div>
                                            </div>
                                        </div>
                                    </div><!-- /.row -->
                                </div>
                            </div><!-- /.form-group -->
                            
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>توضیحات(اختیاری):</label>
                                    <span class="counter-box inline-block ltr">
                                        <span class="counter text-inverse">0</span> / 250
                                    </span>
                                </div>
                                <div class="col-sm-8">
                                    <textarea tabindex="9" maxlength="250" id="txt-description" class="form-control has-counter" placeholder="توضیحات..."></textarea>
                                </div>
                            </div><!-- /.form-group -->

                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>تصویر رسید پرداخت(اختیاری):</label>
                                    <label><small>فرمت jgp, jpeg, png, gif تا حجم یک مگابایت</small></label>
                                </div>
                                <div class="col-sm-8 relative">
                                    <input id="imgInp" type="file" class="form-control " accept="image/*" style="position: static; opacity: 1;">
                                    <img id="blah" class="img-fluid center-block hide" src="" alt="payment image" />
                                    <button id="btn-clear-image" type="button" class="hide">×</button>
                                </div>
                            </div><!-- /.form-group -->
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-block ltr">
                    <button type="button" class="btn bg-gradient-primary font-md mb-0 float-end" id="btn-save-card2card">ثبت تراکنش</button>
                    <button type="button" class="btn btn-outline-secondary mb-0" data-bs-dismiss="modal">انصراف</button>
                </div>
            </div>
        </div>
    </div>
<?php endif;?>

<?php if(isset($show_modal_bank_card)): ?>
    <div id="modal-bank-card" class="modal fade" role="dialog">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    <h4 class="modal-title">افزودن کارت بانکی</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-info">شماره کارت بانکی باید با کد ملی <?= $user_login->national_code ?> مطابقت داشته باشد.</div>
                            <div class="alert alert-danger alert-bank-card d-none"></div>
                        </div><!-- /.col -->
                        
                        <div class="col-12">
                            <form>
                                <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">

                                <div class="form-group row">
                                    <div class="col-12">
                                        <label>شماره کارت بانکی که می‌خواهید با آن پرداخت کنید</label>
                                    </div>
                                    <div class="col-12">
                                        <div class="row card-inputs" required>
                                            <input type="hidden" class="txt-card" name="card_number" title="شماره کارت" required data-validation="validCardNumber">
                                            <div class="col-3">
                                                <input type="text" tabindex="5" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                            </div>
                                            <div class="col-3">
                                                <input type="text" tabindex="4" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                            </div>
                                            <div class="col-3">
                                                <input type="text" tabindex="3" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                            </div>
                                            <div class="col-3">
                                                <input type="text" tabindex="2" class="form-control txt-card-part ltr text-center numeric" maxlength="4">
                                            </div>
                                        </div><!-- /.row -->
                                        <div class="help-block"></div>
                                    </div>
                                </div><!-- /.form-group -->

                            </form>
                        </div><!-- /.col -->
                    </div>

                </div>
                <div class="modal-footer d-block ltr">
                    <button type="button" class="btn bg-gradient-primary font-md mb-0 float-end" id="btn-save-bank-card">ثبت کارت بانکی</button>
                    <button type="button" class="btn btn-outline-secondary mb-0" data-bs-dismiss="modal">انصراف</button>
                </div>
            </div>
        </div>
    </div>
<?php endif;?>

<?php if($notices->list): ?>
    <div class="btn bg-gradient-primary notification-button <?= $settings->notice->btn_place ?>">
        <div class="icon-wrapper">
            <i class="fa fa-bell-o"></i>
            <?php if($notices->unseen_notice_ids): ?>
                <div class="notification-badge bg-red"><?= count($notices->unseen_notice_ids) ?></div>
            <?php endif ?>
        </div>
    </div>

    <!-- Modal -->
    <div id="modal-notifications" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    <h4 class="modal-title"></h4>
                </div>
                <div class="modal-body">
                    <form>
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" name="notice_ids">
                    </form>
                    <div class="accordion-list" id="accordion-notification">
                        <?php foreach($notices->list as $notice): ?>
                            <div class="card overflow-hidden bg-gray" data-id="<?= $notice->id ?>" data-seen="<?= (in_array($notice->id, $notices->unseen_notice_ids)) ? 'false' : 'true' ?>">
                                <div class="card-header" role="tab" id="notification-heading-<?= $notice->id ?>">
                                    <h4 class="card-title">
                                        <a data-bs-toggle="collapse" data-bs-parent="#accordion-notification" href="#notification-<?= $notice->id ?>"><?= $notice->title ?></a>
                                    </h4>
                                    <div class="icon">
                                        <i class="fa fa-bell-o"></i>
                                    </div>
                                </div>
                                <div id="notification-<?= $notice->id ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="notification-heading-<?= $notice->id ?>">
                                    <div class="long-text p-20">
                                        <?= $notice->content ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach;?>
                    </div><!-- /.panel-group -->
                </div><!-- /.modal-body -->
                <div class="modal-footer">
                    <button type="button" class="btn bg-gradient-primary mb-2 ms-auto" id="btn-see-notification"><i class="icon-check"></i> متوجه شدم</button>
                    <!-- <button type="button" class="btn bg-secondary mb-2" data-bs-dismiss="modal"><i class="icon-arrow-right"></i> بازگشت</button> -->
                </div><!-- /.modal-footer -->
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
<?php endif;?>

<!-- JavaScript -->
<script src="<?= base_url() ?>assets/plugins/bootstrap/5/js/bootstrap.bundle.min.js?<?= ($settings->version) ?>"></script>
<script src="<?= base_url() ?>assets/plugins/owl/owl.carousel.min.js?<?= ($settings->version) ?>"></script>
<script src="<?= base_url() ?>assets/plugins/material/material-kit.min.js?<?= ($settings->version) ?>"></script>

<!-- Page JS -->
<?php if (isset($js) && count($js)): ?>
    <?php foreach ($js as $url): ?>
        <script src="<?= base_url($url) . "?" . $settings->version ?>"></script>
    <?php endforeach ?>
<?php endif ?>

<!-- Main JS -->
<script src="<?= base_url() ?>assets/js/karta.js?<?= ($settings->version) ?>"></script>
