<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
$page = (isset($page)) ? $page : '';
?>
<div class="row" id="gateways-box">
    <input type="hidden" id="gateway" name="gateway" value="<?= $default_gateway ?>">
    <?php if($card2card): ?>
        <input type="hidden" name="transfer[reference]">
        <input type="hidden" name="transfer[card]">
        <input type="hidden" name="transfer[date]">
        <input type="hidden" name="transfer[clock]">
        <input type="hidden" name="transfer[description]">
        <input type="file" class="d-none" name="image">
    <?php endif; ?>
    <?php if($card2card && $gateways): ?>
        <div class="col-12 gateway-methods">
            <span class="gateway-method <?php if($default_gateway != 'card2card') echo 'active'; ?>" data-tab="online">
                <i class="fa fa-check"></i>
                پرداخت از درگاه
            </span>
            <span class="or">یا</span>
            <span class="gateway-method <?php if($default_gateway == 'card2card') echo 'active'; ?>" data-tab="card2card">
                <i class="fa fa-check"></i>
                کارت به کارت
            </span>
        </div>
    <?php endif; ?>
    <div class="col-12 gateway-contents">
        <?php if ($gateways): ?>
            <div class="row gateway-content <?php if($default_gateway == 'card2card') echo 'd-none'; ?>" data-tab="online">
                <?php if(!$card2card && $page != 'charge'): ?>
                    <div class="col-3 col-sm-3 col-md-5 col-lg-4 col-xl-3 pt-2">درگاه:</div>
                <?php endif; ?>
                <div class="<?= (!$card2card && $page != 'charge') ? 'col-9 col-sm-9 col-md-7 col-lg-8 col-xl-9' : 'col-12' ?>">
                    <?php foreach ($gateways as $gateway): ?>
                        <img src="<?= base_url($gateway->image) ?>" class="img-gateway has-tooltip <?=($gateway->title_en == $default_gateway)?'active':''; ?>" data-value="<?= $gateway->title_en ?>" data-currency="<?= $gateway->dollar_base ? 'dollar' : '' ?>" title="<?= $gateway->title_fa ?>" alt="<?= $gateway->title_fa ?>"></option>
                    <?php endforeach; ?>
                </div>
                <?php if(in_array('bank_card', $settings->verify_when_buy)): ?>
                    <div class="col-12 <?= ($page == 'charge') ? 'col-lg-8 col-md-12 col-sm-8  m-auto' : '' ?>">
                        <div class="form-group text-end">
                            <label class="lbl-select-card">انتخاب کارت بانکی <span class="small">(اجباری)</span></label>
                            <a href="javascript:void(0);" class="btn-add-card">افزودن کارت بانکی</a>
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-credit-card font-lg"></i>
                                </span>
                                <select class="form-select" id="slc-bank-card" name="card_number" title="کارت بانکی" required>
                                    <option disabled selected>انتخاب کنید</option>
                                    <?php if($bank_cards): ?>
                                        <?php foreach ($bank_cards as $item): ?>
                                            <option value="<?= $item->card_number ?>"><?= bankCardFormat($item->card_number) ?></option>
                                        <?php endforeach ?>
                                    <?php endif ?>
                                </select>
                            </div><!-- /.input-group -->
                            <div class="help-block"></div>
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                <?php endif ?>
            </div><!-- /.row -->
        <?php endif; ?>
        <?php if ($card2card): ?>
            <div class="row gateway-content <?php if($default_gateway != 'card2card') echo 'd-none'; ?>" data-tab="card2card">
                <?php if(!$gateways): ?>
                    <div class="col-5 col-sm-5 col-md-5 col-lg-4 col-xl-3 pt-2">کارت به کارت:</div>
                <?php endif; ?>
                <div class="<?= (!$gateways) ? 'col-7 col-sm-7 col-md-7 col-lg-8 col-xl-9' : 'col-12' ?>">
                    <img src="<?= base_url($card2card->image) ?>" class="img-gateway has-tooltip active" data-value="<?= $card2card->title_en ?>" title="<?= $card2card->title_fa ?>" alt="<?= $card2card->title_fa ?>"></option>
                </div>
            </div>
        <?php endif; ?>
    </div><!-- /.col-12 -->
    <div class="col-12 gateway-error">
        <div class="help-block text-danger"></div>
    </div>
</div><!-- /.row -->