<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

if($is_spa){
    $categoryUrl = '';
    $productUrl = '';
    if($selected_category){
        $categoryUrl = $selected_category->slug ? base_url("category/$selected_category->slug") : base_url("category/$selected_category->id");
    }
    if($selected_product){
        $productUrl = $selected_product->slug ? base_url("product/$selected_product->slug") : base_url("product/$selected_product->id") ;
        $categoryUrl = (isset($selected_product->category_slug) && $selected_product->category_slug) ? base_url("category/$selected_product->category_slug") : base_url("category/$selected_product->category_id");
    }
}
?>

<script>
    <?php if($is_spa): ?>
        let categoryUrl = "<?= $categoryUrl ?>";
        let productUrl = "<?= $productUrl ?>";
    <?php endif ?>

    var prices = [];
    <?php
    if (isset($prices) && $prices) {
        foreach ($prices as $price) {
            ?>
            prices.push({product_id: '<?= $price->product_id ?>', price: '<?= $price->price ?>', sellPrice: '<?= $price->sell_price ?>', fromQty: '<?= $price->from_qty ?>', toQty: '<?= $price->to_qty ?>'});
            <?php
        }
    }
    ?>
</script>
<div class="home-page">
    <?php if (($is_spa || (!$is_spa && $step == 1)) && !$categories): ?>
        <div class="container m-t-30 m-b-20">
            <div class="alert alert-danger shadow">در حال حاضر دسته ای برای محصولات فروشگاه تعریف نشده است.</div>
        </div><!-- /.container -->
    <?php else: ?>
        <div class="container" id="top-form">
            <div class="row">
                <div class="col-md-12 top-alerts">
                    <?php if ($this->session->flashdata('frontend_error')): ?>
                        <div class="alert alert-danger">
                            <?= $this->session->flashdata('frontend_error') ?>
                        </div>
                    <?php elseif ($this->session->flashdata('frontend_success')): ?>
                        <div class="alert alert-success">
                            <?= $this->session->flashdata('frontend_success') ?>
                        </div>
                    <?php elseif ($this->session->flashdata('order_message')): ?>
                        <div class="alert alert-danger">
                            <?= $this->session->flashdata('order_message') ?>
                        </div>
                    <?php endif ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
            <div class="row">
                <div class="col-xl-<?= ($count_per_row==3) ? 9 : 6 ?> col-12 m-auto <?= !$is_mobile && !isset($sliders) ? 'm-t-30' : '' ?>">
                    <?php
                    
                    $full_half_empty = '';
                    $tab_1_class = 'current';
                    $tab_2_class = 'disabled';
                    $tab_3_class = 'disabled';
                    if($selected_category){
                        $full_half_empty = 'half';
                        $tab_1_class = '';
                        $tab_2_class = 'current';
                    } else if($selected_product){
                        $full_half_empty = 'full';
                        $tab_1_class = '';
                        $tab_2_class = '';
                        $tab_3_class = 'current';
                    }

                    // Data url for step 2
                    $tab_2_url = '';
                    if(!$is_spa && $selected_product && $step == 3){
                        $tab_2_url = ($selected_product->category_slug) ? base_url("category/$selected_product->category_slug") : base_url("category/$selected_product->category_id");
                    }

                    ?>
                    <div class="tabs-box <?= $full_half_empty ?>">
                        <ul class="tabs">
                            <li class="tab-link <?= $tab_1_class ?>" data-tab="tab-1" data-url="<?= (!$is_spa && $step == 1) ? '' : base_url('') ?>">
                                <div class="caption first">
                                    <h3>
                                        <span class="level"><b>1</b></span>
                                        <span class="xxs-hide">انتخاب </span>
                                        دسته
                                    </h3>
                                </div>
                            </li>
                            <li class="tab-link <?= $tab_2_class ?>" data-tab="tab-2" data-url="<?= $tab_2_url ?>">
                                <div class="caption second">
                                    <h3>
                                        <span class="level"><b>2</b></span>
                                        <span class="xxs-hide">انتخاب </span>
                                        محصول
                                    </h3>
                                </div>
                            </li>
                            <li class="tab-link <?= $tab_3_class ?>" data-tab="tab-3" data-url="">
                                <div class="caption third">
                                    <h3>
                                        <span class="level"><b>3</b></span>
                                        <span class="xxs-hide">ورود مشخصات و</span>
                                        پرداخت
                                    </h3>
                                </div>
                            </li>
                        </ul>
                    </div><!-- /.tabs-box -->
                    <div class="tabs-box-shadow"></div>
                </div><!-- /.col -->
                
                
                <div class="col-12 <?= ($vertical_layout) ? 'vertically' : '' ?>  <?= ($mobile_vertical_layout) ? 'mobile-vertically' : '' ?>">
                    <?php if($is_spa || (!$is_spa && $step == 1)): ?>
                        <div id="tab-1" class="tab-content <?php if($selected_product || $selected_category) echo 'hide'; ?>">
                            <?= $this->load->view('steps/step_1', $this->data, true); ?>
                        </div><!-- /.tab-content -->
                    <?php endif; ?>

                    <?php if($is_spa || (!$is_spa && $step == 2)): ?>
                        <div id="tab-2" class="tab-content <?php if(!$selected_category) echo 'hide'; ?>">
                            <?= $this->load->view('steps/step_2', $this->data, true); ?>
                        </div><!-- /.tab-content -->
                    <?php endif; ?>
                    
                    <?php if($is_spa || (!$is_spa && $step == 3)): ?>
                        <div id="tab-3" class="tab-content <?php if(!$selected_product) echo 'hide'; ?>">
                            <?= $this->load->view('steps/step_3', $this->data, true); ?>
                        </div><!-- /.tab-content -->
                    <?php endif; ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- container -->
        
    <?php endif; ?>
</div>

<?php if(isset($rules_page) && $rules_page): ?>
    <!-- Modal -->
    <div id="modal-rules" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><?= $rules_page->title ?></h4>
                </div>
                <div class="modal-body">
                    <?= $rules_page->content ?>
                </div>
                <!-- <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                </div> -->
            </div>

        </div>
    </div>
<?php endif;?>

<div id="product-info" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                <h4 class="modal-title"></h4>
            </div>
            <div class="modal-body">
                <div class="loading text-center">
                    <p>
                        <i class="fa fa-spinner fa-pulse fa-fw"></i>
                        <span>لطفا صبور باشید ...</span>
                    </p>
                </div>
                <div class="content"></div>
            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-info" data-dismiss="modal">بستن</button>
            </div> -->
        </div>

    </div>
</div>
<script>
    var categories = [];
    var isSPA = <?= intval($settings->buy_steps->is_spa) ?>;
    var selectedCategoryId = <?= ($selected_category) ? intval($selected_category->id) : 0 ?>;
    <?php if ($is_spa && $categories): ?>
        <?php foreach ($categories as $item): ?>
            categories.push(
                {
                    id: '<?= $item->id?>',
                    description: `<?= str_replace('`', "'", $item->description) ?>`,
                    fields: JSON.parse(`<?= json_encode($item->fields, JSON_UNESCAPED_UNICODE) ?>`)
                }
            );
        <?php endforeach ?>
    <?php endif ?>

    <?php if($selected_product): ?>
        var selectedProduct = <?= $selected_product->id ?>;
        var selectedProductPrice = <?= $selected_product->sell_price ?>;
        var maxQty = <?= $selected_product->max_qty ?>;
    <?php else: ?>
        var selectedProduct = selectedProductPrice = maxQty = 0;
    <?php endif; ?>

    var credit = <?= ($this->user_login) ? $this->user_login->credit : 0 ?>;
    
    <?php if($notices->unseen_notice_ids): ?>
        var unseenNoticeIds = JSON.parse('<?= json_encode($notices->unseen_notice_ids) ?>');
    <?php endif ?>

    $(document).ready(function(){
        <?php if(isset($message_not_exists_ptoduct)): ?>
            noty({
                text: "<?= $message_not_exists_ptoduct ?>",
                type: "error",
                dismissQueue: true,
                timeout: 5000,
                layout: "center",
                closeWith: ["click"],
                maxVisible: 10,
                theme: "flat"
            });
        <?php endif; ?>
    });
</script>