<!DOCTYPE html>
<html lang="fa" dir="rtl">
    <head>
        <title><?= $settings->site_name ?></title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" name="viewport" >
        <meta name="description" content="<?= $settings->site_name ?>">
        <meta name="author" content="http://www.rayanik.com">

        <meta property="og:title" content="<?= $settings->site_name ?>">
        <meta property="og:site_name" content="<?= $settings->site_name ?>">
        <meta property="og:description" content="<?= $settings->site_name ?>">
        <meta property="og:image" content="<?=base_url($settings->logo)?>">

        <link rel="icon" type="image/png" href="<?= base_url($settings->favicon) ?>">

        <!--  CSS  -->
        <link href="<?=base_url('/assets/plugins/bootstrap/dist/css/bootstrap.min.css')?>" rel="stylesheet">
        <link href="<?=base_url('/assets/plugins/bootstrap-rtl/dist/css/bootstrap-rtl.min.css')?>" rel="stylesheet">
        <link href="<?=base_url('/assets/css/material-kit.css')?>" rel="stylesheet">
        <link href="<?=base_url('/assets/css/style.css')?>" rel="stylesheet">
    </head>
    <body>
        <!--BEGIN CONTENT-->
        <section class="main">
            <div class="container">
                <div class="row">
                    <?php if(!empty($settings->offline_image) && file_exists($settings->offline_image)): ?>
                        <div class="col-xs-12">
                            <div class="p-t-20 p-b-20">
                                <img class="img-responsive center-block" src="<?=base_url($settings->offline_image)?>" alt="<?= $settings->site_name?>">
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-xs-12">
                        <div class="alert alert-info curve shadow p-t-50 p-b-50">
                            <p class="text-center"><?= nl2br($settings->offline_text) ?></p>
                        </div>
                    </div>
                </div><!-- /row -->
            </div><!-- /container -->
        </section><!-- /main -->
    </body>
</html>
