<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH')) exit('No direct script access allowed');
?>  
<div class="row">
    <div class="col-xl-<?= $count_per_row*3 ?> m-auto">
        <div class="row gx-3  <?php if($categories && count($categories) < $count_per_row) echo 'justify-content-center'; ?>">
            <?php
            foreach ($categories as $category_key => $category) {
                // Category image
                if($image_size == 'large'){
                    if ($category->large_image && file_exists($category->large_image)) {
                        $category_img = $category->large_image;
                    } else if($settings->default_category_large_image && file_exists($settings->default_category_large_image)){
                        $category_img = $settings->default_category_large_image;
                    } else {
                        $category_img = 'assets/images/default-image-480x360.png';
                    }
                } else {
                    if ($category->image && file_exists($category->image)) {
                        $category_img = $category->image;
                    } else if($settings->default_category_image && file_exists($settings->default_category_image)){
                        $category_img = $settings->default_category_image;
                    } else {
                        $category_img = 'assets/images/default-image-80x80.png';
                    }
                }
                $categories[$category_key]->image = $category_img;
                $disabled = ($category->has_product) ? '' : 'disabled';
                $active = '';
                if(
                    ($selected_product && $selected_product->category_id == $category->id) ||
                    ($selected_category && $selected_category->id == $category->id)
                ){
                    $active = 'active';
                }

                $url = $category->slug ? base_url("category/".urlencode($category->slug)) : base_url("category/$category->id");
                ?>
                <div class="col-xl-<?= $appropriate_col ?> col-lg-4 col-md-6 col-12">
                    <div class="category <?= $active ?> <?= $disabled ?>" data-id="<?= $category->id ?>" data-url="<?= $url ?>">
                        <?php if(!$is_spa): ?>
                            <a href="<?= $url ?>">
                        <?php endif; ?>
                        <div class="like-table">
                            <div class="like-tablecell">
                                <img src="<?= base_url($category_img) ?>" alt="<?= $category->title_fa ?>">
                            </div><!-- /.like-tablecell -->
                            <div class="like-tablecell">
                                <h2><?= $category->title_fa ?> </h2>
                                <h2 class="en"><?= $category->title_en ?> </h2>
                            </div><!-- /.like-tablecell -->

                        </div><!-- /.like-table -->
                        <?php if(!$is_spa): ?>
                            </a>
                        <?php endif; ?>
                    </div><!-- /.category -->
                </div><!-- /.col -->
                <?php
                // $c++;
            }
            ?>
        </div><!-- /.row -->
    </div><!-- /.col -->
</div><!-- /.row -->
<?php if(isset($site_description) && $site_description): ?>
    <article  class="category-description">
        <div class="text">
            <?= $site_description ?>
        </div>
        <button type="button" class="btn bg-gradient-primary btn-toggle-description d-none">اطلاعات بیشتر</button>
    </article>
<?php endif ?>