<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1>تیکت(پشتیبانی)</h1>
                </div>
                <div class="row">
                    <div class="col-lg-8 m-auto">
                        <?php if ($this->session->flashdata('frontend_error')) : ?>
                            <div class="alert alert-danger">
                                <?= $this->session->flashdata('frontend_error') ?>
                            </div>
                        <?php elseif ($this->session->flashdata('frontend_success')) : ?>
                            <div class="alert alert-success">
                                <?= $this->session->flashdata('frontend_success') ?>
                            </div>
                        <?php endif; ?>
                    </div><!-- /col -->
                </div><!-- /row -->
                <?php if ($tickets) : ?>
                    <p>
                        <a href="<?= base_url('tickets/add') ?>"  class="btn bg-gradient-primary">
                            تیکت جدید
                        </a>
                    </p>
                    <?php foreach ($tickets as $item) : ?>
                        <div class="row my-card standard-cards">
                            <div class="col-lg-6">
                                <a href="<?= base_url("tickets/messages/$item->id")?>">
                                    <?php if($item->unread_user):?>
                                        <span class="badge-unread"><?= $item->unread_user ?></span>
                                    <?php endif; ?>
                                    <span class="ticket-title"><?= html_escape($item->title) ?></span>
                                </a>
                            </div><!-- /.col -->
                            <div class="col-lg-6 col-12">
                                <div class="row">
                                    <div class="col-lg-4 col-5">
                                        <span class="d-inline d-none d-sm-inline d-md-inline d-lg-none d-xl-non">وضعیت:</span>
                                        <?php if($item->status == 'close'): ?>
                                            <span class="text-danger">بسته شده</span>
                                        <?php elseif($item->last_sender == 'customer'): ?>
                                            <span class="text-warning">در انتظار پاسخ</span>
                                        <?php else: ?>
                                            <span class="text-success">پاسخ داده شده</span>
                                        <?php endif; ?>
                                    </div><!-- /.col -->
                                    <div class="col-lg-5 col-7 text-start text-lg-end">
                                        <span><?= $item->created ?></span>
                                    </div><!-- /.col -->
                                    <div class="col-lg-3 col-12 text-lg-start text-center">
                                        <a class="btn bg-gradient-primary m-b-0" href="<?= base_url("tickets/messages/$item->id")?>" >مشاهده</a>
                                    </div><!-- /.col -->
                                </div><!-- /.row -->
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    <?php endforeach; ?>
                    <div class="text-center">
                        <?= $this->pagination->create_links(); ?>
                    </div><!-- /.text-center -->
                <?php else : ?>
                    <div class="row">
                        <div class="col-lg-8 m-auto">
                            <div class="alert alert-info text-center">
                                <p>
                                    <i class="fa fa-info-circle"></i>
                                    کاربر گرامی شما تا کنون پیامی نفرستاده اید.
                                </p>
                            </div><!-- /.alert -->
                            <p class="text-center">
                                <a href="<?= base_url('tickets/add') ?>"  class="btn bg-gradient-primary">
                                    ثبت تیکت
                                </a>
                            </p>
                        </div>
                    </div>
                <?php endif; ?>

            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->