<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="profile-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-10 col-12 m-auto">
                    <h1 class="text-center bold mb-3"><i class="fa fa-edit"></i> ویرایش پروفایل</h1>

                    <div class="card px-4 py-4">
                        <div class="row" id="alert-message">
                            <div class="col-12">
                                <?php
                                if (isset($message_danger)) {
                                    ?>
                                    <div class="alert alert-danger text-center curve">
                                        <?= $message_danger ?>
                                    </div>
                                    <?php
                                } elseif (isset($message_success)) {
                                    ?>
                                    <div class="alert alert-success text-center curve">
                                        <?= $message_success ?>
                                    </div>
                                    <?php
                                }
                                
                                if ($this->session->flashdata('frontend_error')) {
                                    ?>
                                    <div class="alert alert-danger curve text-center">
                                        <?= $this->session->flashdata('frontend_error') ?>
                                    </div>
                                    <?php
                                }

                                if ($this->session->flashdata('frontend_success')) {
                                    ?>
                                    <div class="alert alert-success curve text-center">
                                        <?= $this->session->flashdata('frontend_success') ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <form action="<?= base_url('users/editProfile') ?>" method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                                
                                <div class="row">
                                    <div class="col-12">
                                        <label class="m-t-10 m-b-0">
                                            شماره همراه
                                            <small class="text-gray">(غیر قابل ویرایش)</small>
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control disabled ltr" value="<?= $user->username ?>" disabled readonly>
                                    </div><!-- /.col -->
                                </div><!-- /.row -->

                                <div class="row">
                                    <div class="col-12">
                                        <label class="m-t-10 m-b-0">
                                            کد ملی
                                            <?php if(in_array('national_code', $user_login->matched_fields)) :?>
                                                <small class="text-gray">(غیر قابل ویرایش)</small>
                                            <?php endif ?>
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control ltr text-left numeric" value="<?= set_value('national_code', $user->national_code) ?>" <?php if(in_array('national_code', $user_login->matched_fields)) echo 'disabled readonly'; ?>>
                                    </div><!-- /.col -->
                                </div><!-- /.row -->

                                <div class="row">
                                    <div class="col-12">
                                        <label class="m-t-10 m-b-0">
                                            نام
                                            <?php if(in_array('birth_date', $user_login->matched_fields)) :?>
                                                <small class="text-gray">(غیر قابل ویرایش)</small>
                                            <?php endif ?>
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control" name="first_name" value="<?= set_value('first_name', $user->first_name) ?>" <?php if(in_array('birth_date', $user_login->matched_fields)) echo 'disabled readonly'; ?>>
                                    </div>
                                </div><!-- /.row -->

                                <div class="row">
                                    <div class="col-12">
                                        <label class="m-t-10 m-b-0">
                                            نام خانوادگی
                                            <?php if(in_array('birth_date', $user_login->matched_fields)) :?>
                                                <small class="text-gray">(غیر قابل ویرایش)</small>
                                            <?php endif ?>
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control" name="last_name" value="<?= set_value('last_name', $user->last_name) ?>" <?php if(in_array('birth_date', $user_login->matched_fields)) echo 'disabled readonly'; ?>>
                                    </div>
                                </div><!-- /.row -->
    
                                <div class="row">
                                    <div class="col-12">
                                        <label class="m-t-10 m-b-0"> ایمیل</label>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control ltr text-left" name="email" value="<?= set_value('email', $user->email) ?>">
                                    </div><!-- /.col -->
                                </div><!-- /.row -->
                                
                                <?php if($user->image && file_exists($user->image)){ ?>
                                    <div class="col-12 mt-4"> 
                                        <a href="<?= base_url($user->image); ?>" target="_blank">
                                            <img src="<?= base_url($user->image); ?>" width="200" class="img-thumbnail img-responsive" alt="<?= html_escape("$user->first_name $user->last_name") ?>">
                                        </a>
                                    </div>
                                <?php } ?>
                                <div class="col-12">
                                    <label for="formFile" class="form-label m-t-10 m-b-0">آپلود تصویر</label>
                                    <input class="form-control form-control-lg" id="formFile" type="file" name="image">
                                </div><!-- /.col -->

                                <div class="col-md-6 mx-auto mt-5">
                                    <button class="btn bg-gradient-primary w-100" name="submit" value="submit">
                                        ذخیره پروفایل
                                    </button>
                                </div><!-- /.col -->
                            </form>
                        </div><!-- /.row -->
                    </div><!-- /.card -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div><!-- /.profile-content -->
</div><!-- /.main -->