/*
 * This file/code is part of Paper UI project.
 *
 * Paper UI - is a modern front-end framework based on Material Design by Google
 * https://github.com/virtyaluk/paper-ui
 *
 * Copyright (c) 2015 Bohdan Shtepan
 * http://modern-dev.com/
 *
 * Licensed under the MIT license.
 */
 "use strict";!function(t,e){if("function"==typeof define&&define.amd)define("PaperRipple",["module"],e);else if("undefined"!=typeof exports)e(module);else{var i={exports:{}};e(i),t.PaperRipple=i.exports}}(this,function(t){function e(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}var i=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),n=function(){function t(i){return e(this,t),this._element=i,this.width=this.boundingRect.width,this.height=this.boundingRect.height,this.size=Math.max(this.width,this.height),this}return i(t,[{key:"distanceToFarthestCorner",value:function(e){var i=e.x,n=void 0===i?0:i,s=e.y,a=void 0===s?0:s;return Math.max(t.euclideanDistance({x:n,y:a},{x:0,y:0}),t.euclideanDistance({x:n,y:a},{x:this.width,y:0}),t.euclideanDistance({x:n,y:a},{x:0,y:this.height}),t.euclideanDistance({x:n,y:a},{x:this.width,y:this.height}))}},{key:"contains",value:function(t){var e=t.x,i=t.y,n=t.clientX,s=t.clientY,a=this.boundingRect.left,r=this.boundingRect.top,o=this.boundingRect.width,h=this.boundingRect.height,c=e||n||0,u=i||s||0;return c>=a&&a+o>=c&&u>=r&&r+h>=u}},{key:"center",get:function(){return{x:this.width/2,y:this.height/2}}},{key:"boundingRect",get:function(){return this._element.getBoundingClientRect()}}],[{key:"euclideanDistance",value:function(t,e){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}}]),t}(),s=window||void 0,a=s.document,r=function(){return s.performance&&s.performance.now?s.performance.now.bind(s.performance):Date.now}(),o=function(){function t(i){var r=i.$,o=i.recenters,h=void 0===o?!1:o,c=i.center,u=void 0===c?!1:c,d=i.initialOpacity,l=void 0===d?.25:d,p=i.opacityDecayVelocity,y=void 0===p?.8:p;return e(this,t),this.color=s.getComputedStyle(r).color,this.containerRect=new n(r),this.recenters=h,this.center=u,this.initialOpacity=l,this.opacityDecayVelocity=y,this.$wave=a.createElement("div"),this.$wave.classList.add("paper-ripple__wave"),this.$wave.style.backgroundColor=this.color,this.$=a.createElement("div"),this.$.classList.add("paper-ripple__wave-container"),this.$.appendChild(this.$wave),this.resetDefaults(),this}return i(t,[{key:"resetDefaults",value:function(){return this.maxRadius=0,this.touchDownStarted=0,this.touchUpStarted=0,this.startPosition={x:0,y:0},this.endPosition={x:0,y:0},this}},{key:"draw",value:function(){var t=void 0,e=this.radius/(this.containerRect.size/2),i=this.containerRect.center,n=this.currentPosition,s={x:n.x-i.x,y:n.y-i.y};return this.$wave.style.opacity=this.opacity,t="translate("+s.x+"px, "+s.y+"px)",this.$.style.webkitTransform=t,this.$.style.mozTransform=t,this.$.style.msTransform=t,this.$.style.oTransform=t,this.$.style.transform="translate3d("+s.x+"px, "+s.y+"px, 0)",t="scale("+e+","+e+")",this.$wave.style.webkitTransform=t,this.$wave.style.mozTransform=t,this.$wave.style.msTransform=t,this.$wave.style.oTransform=t,this.$wave.style.transform="scale3d("+e+","+e+", 1)",this}},{key:"downAction",value:function(){var t=arguments.length<=0||void 0===arguments[0]?null:arguments[0],e=this.containerRect.center;return this.resetDefaults(),this.touchDownStarted=r(),this.startPosition=this.center||!t?e:{x:(t.clientX||t.x)-this.containerRect.boundingRect.left,y:(t.clientY||t.y)-this.containerRect.boundingRect.top},this.endPosition=this.recenters?e:this.endPosition,this.maxRadius=this.containerRect.distanceToFarthestCorner(this.startPosition),this.$.style.top=(this.containerRect.height-this.containerRect.size)/2+"px",this.$.style.left=(this.containerRect.width-this.containerRect.size)/2+"px",this.$.style.width=this.containerRect.size+"px",this.$.style.height=this.containerRect.size+"px",this}},{key:"upAction",value:function(){return this.isTouchDown?(this.touchUpStarted=r(),this):this}},{key:"remove",value:function(){return this.$.parentNode.removeChild(this.$),this}},{key:"touchDownElapsed",get:function(){var t;return this.touchDownStarted?(t=r()-this.touchDownStarted,this.touchUpStarted&&(t-=this.touchUpElapsed),t):0}},{key:"touchUpElapsed",get:function(){return this.touchUpStarted?r()-this.touchUpStarted:0}},{key:"touchDownElapsedSeconds",get:function(){return this.touchDownElapsed/1e3}},{key:"touchUpElapsedSeconds",get:function(){return this.touchUpElapsed/1e3}},{key:"mouseInteractionSeconds",get:function(){return this.touchDownElapsedSeconds+this.touchUpElapsedSeconds}},{key:"radius",get:function(){var e=1.1*Math.min(Math.sqrt(Math.pow(this.containerRect.width,2)+Math.pow(this.containerRect.height,2)),t.MAX_RADIUS)+5,i=1.1-.2*(e/t.MAX_RADIUS),n=this.mouseInteractionSeconds/i,s=e*(1-Math.pow(80,-n));return Math.abs(s)}},{key:"opacity",get:function(){return this.touchUpStarted?Math.max(0,this.initialOpacity-this.touchUpElapsedSeconds*this.opacityDecayVelocity):this.initialOpacity}},{key:"outerOpacity",get:function(){return Math.max(0,Math.min(.3*this.touchUpElapsedSeconds,this.opacity))}},{key:"isWaveFullyOpaque",get:function(){return this.opacity<.01&&this.radius>=Math.min(this.maxRadius,t.MAX_RADIUS)}},{key:"isMaxRadiusReached",get:function(){return this.opacity>=this.initialOpacity&&this.radius>=Math.min(this.maxRadius,t.MAX_RADIUS)}},{key:"isAnimationComplete",get:function(){return this.touchUpStarted?this.isWaveFullyOpaque:this.isMaxRadiusReached}},{key:"translationFraction",get:function(){return Math.min(1,this.radius/this.containerRect.size*2/Math.sqrt(2))}},{key:"currentPosition",get:function(){var t=this.translationFraction,e=this.startPosition.x,i=this.startPosition.y;return this.endPosition.x&&(e=this.startPosition.x+t*(this.endPosition.x-this.startPosition.x)),this.endPosition.y&&(i=this.startPosition.y+t*(this.endPosition.y-this.startPosition.y)),{x:e,y:i}}},{key:"isTouchDown",get:function(){return this.touchDownStarted&&!this.touchUpStarted}}]),t}();o.MAX_RADIUS=300;var h=function(){function t(i){e(this,t);var n=i||{},s=n.initialOpacity,a=void 0===s?.25:s,r=n.opacityDecayVelocity,o=void 0===r?.8:r,h=n.recenters,c=void 0===h?!1:h,u=n.center,d=void 0===u?!1:u,l=n.round,p=void 0===l?!1:l,y=n.target,v=void 0===y?null:y;return this.initialOpacity=a,this.opacityDecayVelocity=o,this._waves=[],this._initTarget(i&&i.nodeType?i:v&&v.nodeType?v:null),this.recenters=c||this.recenters,this.center=d||this.center,this.round=p||this.round,this}return i(t,[{key:"_initTarget",value:function(){var t=arguments.length<=0||void 0===arguments[0]?null:arguments[0],e=e||window.document;return this.$||(this.$=t||e.createElement("div"),this.$.classList.add("paper-ripple")),this.$background||(this.$background=t&&t.querySelector(".paper-ripple__background")||e.createElement("div"),this.$background.classList.add("paper-ripple__background"),this.$.appendChild(this.$background)),this.$waves||(this.$waves=t&&t.querySelector(".paper-ripple__waves")||e.createElement("div"),this.$waves.classList.add("paper-ripple__waves"),this.$.appendChild(this.$waves)),this}},{key:"addWave",value:function(){var t=new o(this);return this.$waves.appendChild(t.$),this.$background.style.backgroundColor=t.color,this._waves.push(t),t}},{key:"downAction",value:function(t){var e=this.addWave();return e.downAction(t),this.animate(),this}},{key:"upAction",value:function(){return this._waves.forEach(function(t){t.upAction()}),this.animate(),this}},{key:"removeWave",value:function(t){var e=this._waves.indexOf(t);return 0>e?this:(this._waves.splice(e,1),t.remove(),this)}},{key:"animate",value:function(){var t=void 0,e=void 0,i=void 0;for(t=0,e=this._waves.length;e>t;t++)i=this._waves[t],i&&(i.draw(),this.$background.style.opacity=i.outerOpacity,i.isWaveFullyOpaque&&!i.isMaxRadiusReached&&this.removeWave(i));return this.shouldKeepAnimating||0!==this._waves.length?window.requestAnimationFrame(this.animate.bind(this)):this.$background.style.backgroundColor=null,this}},{key:"recenters",get:function(){return this.$.hasAttribute("recenters")},set:function(t){this.$[t?"setAttribute":"removeAttribute"]("recenters","")}},{key:"center",get:function(){return this.$.hasAttribute("center")},set:function(t){this.$[t?"setAttribute":"removeAttribute"]("center","")}},{key:"round",get:function(){return this.$.classList.contains("paper-ripple--round")},set:function(t){this.$.classList.toggle("paper-ripple--round",t)}},{key:"shouldKeepAnimating",get:function(){return this._waves.some(function(t){return!t.isAnimationComplete})}}]),t}();t.exports=h});
